#include <iostream>
#include <vector>
#include <queue>
#include <set>
#include <algorithm>
using namespace std;

void dfs(vector<int> g[], set<int>& naPath, vector<int>& currPath, int from, int to) {
  queue<vector<int>> q;
  q.push({from});
  int currEl;
  bool valid;

  while (!q.empty()) {
    currPath = q.front();
    q.pop();
    currEl = currPath.back();

    if (currEl == to) {
      for (auto el : currPath) {
        naPath.insert(el);
      }
      continue;
    }

    for (auto next : g[currEl]) {
      valid = true;
      for (auto el : currPath) {
        if (el == next) {
          valid = false;
          break;
        }
      }

      if (valid) {
        currPath.push_back(next);
        q.push(currPath);
        currPath.pop_back();
      }
    }
  }
}

int median(vector<int>& a, int n) {
  sort(a.begin(), a.end());
  return a[(n+1)/2-1];
}

int main() {
  int n, m, q, p, u, v;
  scanf("%d %d %d %d", &n, &m, &q, &p);

  vector<int> g[n+1];
  int a[n+1];

  for (int i=1; i<=n; i++) scanf("%d", &a[i]);
  for (int i=0; i<m; i++) {
    scanf("%d %d", &u, &v);
    g[u].push_back(v);
    g[v].push_back(u);
  }

  int ans[q+1], a1, b1, from, to;
  ans[0] = 0;

  for (int i=1; i<=q; i++) {
    scanf("%d %d", &a1, &b1);
    from = (a1+ans[i-1]*p-1)%n + 1;
    to = (b1+ans[i-1]*p-1)%n + 1;

    set<int> naPath;
    vector<int> currPath;

    dfs(g, naPath, currPath, from, to);

    vector<int> res;
    for (auto el : naPath) {
      res.push_back(a[el]);
    }

    ans[i] = median(res, res.size());
    printf("%d\n", ans[i]);
  }
  return 0;
}